/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.comm.TEInterface;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTComboBox;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.util.SCTSelection;
import com.quantumdata.std.SerialConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class HostPortTestDialog
extends JDialog
implements ActionListener {
    private SCTButton okButton;
    private SCTButton cancelButton;
    private SCTComboBox baudrateComboBox;
    private SCTLabel baudrateLabel;

    public HostPortTestDialog(JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.init();
    }

    public HostPortTestDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.init();
    }

    private void init() {
        Container container = this.getContentPane();
        this.setTitle("Port Settings");
        container.add(this.testPanel());
        this.setSize(300, 150);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                HostPortTestDialog.this.setSize(300, 150);
            }
        });
        SCTConstants.screenCenterPlacement(this);
    }

    private SCTPanel testPanel() {
        SCTPanel sCTPanel = new SCTPanel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        SCTPanel sCTPanel2 = new SCTPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.baudrateLabel = new SCTLabel("Baudrate :");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.baudrateLabel, gridBagConstraints);
        sCTPanel2.add(this.baudrateLabel);
        this.baudrateComboBox = new SCTComboBox();
        this.baudrateComboBox.addItem("300");
        this.baudrateComboBox.addItem("600");
        this.baudrateComboBox.addItem("1200");
        this.baudrateComboBox.addItem("2400");
        this.baudrateComboBox.addItem("4800");
        this.baudrateComboBox.addItem("9600");
        this.baudrateComboBox.addItem("19200");
        this.baudrateComboBox.addItem("38400");
        this.baudrateComboBox.addItem("115200");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.baudrateComboBox, gridBagConstraints);
        sCTPanel2.add(this.baudrateComboBox);
        SCTPanel sCTPanel3 = new SCTPanel(new FlowLayout(2, 10, 0));
        this.okButton = new SCTButton("OK");
        this.okButton.addActionListener(this);
        sCTPanel3.add(this.okButton);
        this.cancelButton = new SCTButton("Cancel");
        this.cancelButton.addActionListener(this);
        sCTPanel3.add(this.cancelButton);
        sCTPanel.add((Component)sCTPanel2, "North");
        sCTPanel.add((Component)sCTPanel3, "South");
        return sCTPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            MessageOptionPane messageOptionPane = new MessageOptionPane();
            try {
                Object object = this.baudrateComboBox.getSelectedItem();
                if (object == null) {
                    MessageOptionPane.ShowMessage(this.getParent(), "Please select appropriate baud rate.", "Baud Rate Selection");
                    return;
                }
                int n = Integer.parseInt(object.toString());
                SerialConnection serialConnection = (SerialConnection)SCTSelection.instance().getCurrentConnection();
                serialConnection.setBaudRate(n);
                TEInterface.instance().scanInstrument();
                MessageOptionPane.ShowMessage(this.getParent(), "Successfully scanned instrument", "Success");
                this.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MessageOptionPane.ShowMessage(this.getParent(), "Error scanning instrument", "Failure");
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.dispose();
        }
    }
}

